
// Small library to simplify xmlhttp requests
/////////////////////////////////////////////



/**
* Invokes an xmlhttp request
*
* @param     $sColor  A color ['red'|'orange'|'yellow'|'green'|'blue'|'indigo'|'violet']
* @param     $sUrl    The url to which we submit
* @sParams   $sNode   The string id of the node in which we will display the result;
* @return    void
*
*/
function getCount2(sColor, sNode, sUrl)
     {
     var sParams = 'action=getcount&color='+sColor+'&node='+sNode;
     doAjax('POST', sUrl, sParams)
     }
//endFunction



/**
* Performs an xmlhttp request
*
* @param     $sMethod   ['POST'|'GET']
* @param     $sUrl      The url to which we submit
* @sParams   $sParams   The parameters for the submission, in the form of 'action=getcount&color=blue+'&node=red_count';
* @return    void
*
*/
function doAjax(sMethod, sUrl, sParams)
        {
        var xmlhttp;

        if (window.XMLHttpRequest)
          {
          // code for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
          }
        else
          {
          // code for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
        //endIf



        xmlhttp.onreadystatechange = function()
            {
            if (xmlhttp.readyState == 4  && xmlhttp.status == 200)
                {
                oResponse = eval('(' + xmlhttp.responseText + ')');
                document.getElementById('transaction2').innerHTML = JSON.stringify(oResponse);

                var iCount = parseInt(oResponse['count'],10);
                var oNode  = document.getElementById(oResponse['node']);

                if(oNode !== null){oNode.innerHTML = iCount;}else{alert('Cant find Div named ['+sNode+'] to insert count');}
                }
            //endIf
            }
        //endAnonFunc



        if(sMethod == "POST")
            {
            xmlhttp.open(sMethod, sUrl, true);
            xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            xmlhttp.setRequestHeader("Content-length", sParams.length);
            xmlhttp.setRequestHeader("Connection", "close");
            xmlhttp.send(sParams);
            }
        else if(sMethod == "GET")
            {
            sUrl = sUrl+'?'+sParams;
            xmlhttp.open(sMethod, sUrl, true);
            xmlhttp.send();
            }
        //endIf
        }
    //endFunction

