<?php


// Include the DAO
//
///////////////////////////////////////

include_once "data/colors_dao_pdo_sqlite.php";




/**
* A Class to model votes received for a color in various cities
*
* @author    jamesburt@jamesburt.com
* @version   1.0
* @see
*/
class ColorModel
    {
    public function __construct()
        {
        /**************************************
        * Configure
        **************************************/

        $this->oDatabase    = new DaoPdoSqlite_Colors(array('database'=>'colors_db'));
        }
    //endFunction




    /**
    * Returns an array of all colors
    *
    * @return    $aResult  Array of colors
    */
    public function getColors()
        {
        $aResult = $this->oDatabase->getColors();

        return $aResult;
        }
    //endFunction





    /**
    * Returns a count of votes for a certain color.
    *
    * @param     $sColor  The color for which we want to count votes
    * @return    $iResult The count
    */
    public function getVote($sColor)
        {
        $sColor = strtolower($sColor);
        $iResult = $this->oDatabase->getVote($sColor);

        return $iResult;
        }
    //endFunction






    /**
    * Dumps all values of both the colors and votes table.
    *
    * @return    void
    */
    public function getDump()
        {
        $aResult = array();


        $aResult['colors']  = $this->oDatabase->getColors();

        $aResult['votes']   = $this->oDatabase->getVotes();

        return $aResult;
        }
    //endFunction




    ///////////////////////////////////////////////////////////////////////
    //
    // Private Methods
    //
    ///////////////////////////////////////////////////////////////////////



    }
//endClass
?>