<!DOCTYPE HTML>
<html>
    <head>
        <title>XML-HTTP Page</title>

        <meta http-equiv="content-Type" content="text/html; charset=UTF-8" />
        <meta name="robots"             content="all" />
        <meta name="application-name"   content="www.jamesburt.com" />
        <meta name="author"             content="www.jamesburt.com" />
        <meta name="description"        content="XML-HTTP Demo Page" />
        <meta name="viewport"           content="width=device-width, initial-scale=2, minimum-scale=0, user-scalable=yes" />

        <link rel = "SHORTCUT ICON"     href = "http://www.jamesburt.com/static/images/favicon.ico"/>


        <link rel = "stylesheet" href = "http://www.jamesburt.com/static/css/site.css" type = "text/css" media = "screen" />


        <style type = "text/css">
            a:hover {color:red;}
            tr   {background-color:skyblue; padding:5px;}
            td.r {text-align:right; padding:5px;}
            td.l {text-align:left; padding:5px; cursor:hand; cursor:pointer;}
            tfoot{font-weight:bold;}

            div.transaction{border:black solid 2px; padding:3px; margin-top:5px; height:12px;}
        </style>


    <body>

        <div class = "header">
            <div class = "headertitle">Retrieving Votes for a Color by Ajax</div>
            <a class = "headermenu" href = "http://www.jamesburt.com">Home</a>
        </div>



        <div style = "margin-left:50px; margin-right:50px;">


        <table style = "background-color:white;">
            <tbody>
                <tr style = "background-color:white; padding:5px;">
                <td>

                    <?php

                    // $aColors is set in the front controller (index.php)
                    ///////////////////////////////////

                    showColors($aColors);


                    function showColors($aColors)
                        {
                        ?>
                        <table border = '0' cellspacing = '1' cellpadding = '2' style = "background-color:white;">
                            <thead>
                                <tr><th>Color</th><th>Votes</th></tr>
                            </thead>
                            <tbody id = 'color_body'>
                                <?php
                                foreach ($aColors as $row)
                                    {
                                    ?>
                                    <tr>
                                    <td class = 'l' id = 'color_<?=$row['color']?>' onclick = "getCount(this);"><?=$row['color']?></td>
                                    <td class = 'r' id = 'count_<?=$row['color']?>'></td>
                                    </tr>
                                    <?php
                                    }
                                //endFor
                                ?>
                            </tbody>
                            <tfoot>
                                    <tr>
                                    <td class = 'l' onclick = "doTotal();">Total</td>
                                    <td class = 'r' id = 'color_total'></td>
                                    </tr>
                            </tfoot>
                        </table>
                        <?php
                        }
                    //endFunction
                    ?>
                </td>
                <td>
                    <img src = "color_demo.png" />
                </td>
                </tr>
            </tbody>
        </table>
        <br/>
        <div id = "transaction1" class = "transaction"></div>
        <div id = "transaction2" class = "transaction"></div>

        </div>



        <br/>


         <div style = "margin-left:50px; margin-right:50px; border:lightgray solid 1px; padding:10px;">

             This demo is a simple MVC design pattern which demonstrates retrieving values through XMLHTTP Requests (Ajax).<br/>
             <br/>


             This requirement was to retrieve each the votes for each color by an xmlhttp request, and update the view.<br>
             Further, to total the votes which have been retrieved on the page without performing an additional xmlhttp request.<br/>
             <br/>


             The application contains a database of colors, and a database of votes for each color by city.  Clicking on a color name will generate an XMLHTTP request to retrieve the total votes for that color from all cities, and update the table.  Clicking on "Total" will generate a local total for the votes that are displayed on the page.<br/>
             <br/>
             <br/>
             The application does not use any framework, it uses pure PHP and javascript classes and libraries.  It is composed of:<br/>
             <br/>
             <table style = "margin-left:50px;">
             <thead>
             <tr><th>File Name</th><th>Use</th></tr>
             </thead>
             <tbody  style = "text-align:right;">
             <tr><td>index.php</td><td>a front controller and router</td></tr>
             <tr><td>color_controller.php</td><td>a controller</td></tr>
             <tr><td>color_model.php</td><td>a model for the data</td></tr>
             <tr><td>color_view.php</td><td>a view for the user</td></tr>
             <tr><td>json_view.php</td><td>a json view for xmlhttp request</td></tr>
             <tr><td>colors_dao_pdo_sqlite.php</td><td>a DAO for SQLite 3</td></tr>
             <tr><td>colors_db.sqlite</td><td>the database(SQLite 3)</td></tr>
             <tr><td>color_ajax.js</td><td>a JS library for XMLHTTP requests</td></tr>
             <tr><td>json2.js</td><td>MSIE needs this</td></tr>
             <tr><td></td><td></td></tr>
             </tbody>
             </table>

            <br/>
            <br/>
            The database tables behind the scenes are:<br/>
            <br/>
            <table style = "margin-left:50px;">
            <thead>
            <tr><th>The colors table</th></tr>
            </thead>
            <tr><td>red</td></tr>
            <tr><td>orange</td></tr>
            <tr><td>yellow</td></tr>
            <tr><td>green</td></tr>
            <tr><td>blue</td></tr>
            <tr><td>indigo</td></tr>
            <tr><td>violet</td></tr>
            </tbody>
            </table>

            <br/>
            <table style = "margin-left:50px;">
            <thead>
            <tr><th colspan = "3">The votes table</th></tr>
            <tr><th>City</th><th>Color</th><th>Votes</th></tr>
            </thead>
            <tr><td>anchorage</td><td>blue</td><td>10000</td></tr>
            <tr><td>anchorage</td><td>yellow</td><td>15000</td></tr>
            <tr><td>brooklyn</td><td>red</td><td>100000</td></tr>
            <tr><td>brooklyn</td><td>blue</td><td>250000</td></tr>
            <tr><td>detroit</td><td>red</td><td>160000</td></tr>
            <tr><td>selma</td><td>yellow</td><td>15000</td></tr>
            <tr><td>selma</td><td>violet</td><td>5000</td></tr>
            </tbody>
            </table>



             <br/>
             <br/>
             This demo is made without the use of frameworks.<br/>
             That made it a bit more work to complete, but now anyone can download and run it without respect to having either a PHP framework like Codeignitor or a Javascript framework like jQuery.<br/>
             <br/>
             Most well-formed frameworks today will take care of things like XSS, SQL Injection, CSRF, and user-input validation, so I have not bothered with them in the code for this small application.<br/>
             <br/>
             Many things might have been quicker to do if I had used a JS framework like jQuery.  Its concept of selectors for DOM elements, event binding through delegates, and xmlhttp request functions are very convenient.<br/>
             <br/>
             <br/>
             <br/>
             <a href = "colors.zip">Download the source code</a>

         </div>

        <br/>
        <hr style = "width:80%;" />



        <br/>
        <br/>
        <br/>
        <br/>




    <script type = "text/javascript">


        /**
        * Gets the count for votes of a certain color
        *
        * @param     $oNode  A reference to the node clicked upon, we will read the color from here
        * @return    void
        */
        function getCount(oNode)
            {
            var sText   = oNode.id;
            sText       = sText.toLowerCase();
            sText       = sText.split("_")[1];

            oResultNode = oNode.parentNode.getElementsByTagName('td')[1];
            sId         = oResultNode.id;
            sUrl        = 'index.php';

            oResultNode.innerHTML = '';

            document.getElementById('transaction1').innerHTML = "Retrieving Count for Color: "+sText;

            getCount2(sText, sId, sUrl);
            }
        //endFunction





        /**
        * Total all the values currently displayed on the screen
        *
        *  @return void
        */
        function doTotal()
            {
            var oTotalNode = document.getElementById('color_total');
            oTotalNode.innerHTML = '';

            var iTotal = 0;
            var oBody = document.getElementById('color_body');
            var aRows = oBody.getElementsByTagName('tr');

            for (var i = 0; i < aRows.length; i++)
                {
                var aCells = aRows[i].getElementsByTagName('td');
                var oCell  = aCells[1];
                var oText  = oCell.innerHTML;

                var iNum = parseInt(oText,10);

                if(!isNaN(iNum)){iTotal = iTotal + iNum;}
                }
            //endFor
            oTotalNode.innerHTML = iTotal;
            }
        //endFunction

    </script>

    <script type = "text/javascript" src = "color_ajax.js"></script>


    <script type = "text/javascript" src = "json2.js"></script>




    </body>
</html>