<?php



################################################################################3

#

#   DAO

#

#

################################################################################



/**

* PDO-SQLITE DAO for colors database

*

* @author  jamesburt@jamesburt.com

* @version 1.0

*

*



*

*      --------------------------------------------------------

*      --  DDL for Tables IN PHP-PDO for SQLITE

*      --------------------------------------------------------

*

* CREATE TABLE votes (city TEXT, color TEXT, votes INTEGER)

*

*

* CREATE TABLE colors (color TEXT  PRIMARY KEY)

*

*/



class DaoPdoSqlite_Colors

    {

    var $bDebug     = FALSE;        // Should diagnostics be echoed to screen

    var $bEncrypt   = FALSE;        // Should data be encrypted

    var $bConnected = FALSE;        // The database and tables connected

    var $database;                  // The database

    var $table;                     // The table



    var $sDbName;

    var $sTblName;

    var $sFolder;





    /**

    * Constructor, checks for data connectivity

    *

    *

    * @param   $aInit an optional parameter in the form: ['folder'=>'/tmp/CACHE', 'database'=>'myDatabase', 'table'=>'myTable', 'debug'=>FALSE]

    */

    public function __construct($aInit = array())

        {

        // Initialize the cache

        ///////////////////////////////////////////////

        $this->sFolder      = dirname(realpath(__FILE__)).DIRECTORY_SEPARATOR; // Path to sqlite folder



        $this->sDbName      = 'myDb';       // The database name



        $bResult            = date_default_timezone_set('America/New_York');



        // Override with values from $aInit

        ///////////////////////////////////////////////

        if(isset($aInit['folder']))     {$this->sFolder     = $aInit['folder'];}

        if(isset($aInit['database']))   {$this->sDbName     = $aInit['database'];}

        if(isset($aInit['debug']))      {$this->bDebug      = (bool)$aInit['debug'];}



        // Connect to the database

        ///////////////////////////

        $sLabel = "Connect to DB";

        $this->bConnected = FALSE;

        if($this->__getDatabase($this->sDbName))

            {

            $this->bConnected = TRUE;



            // Connect to the table

            ///////////////////////////

            $sLabel = "Connect to TBL";



            $this->bConnected = TRUE;



            if(!$this->__getTable('colors')){$this->bConnected = FALSE;}

            if(!$this->__getTable('votes')){$this->bConnected = FALSE;}

            }

        //endIf



        $this->__doEcho($this->bConnected, $sLabel);

        }

    //endFunction













    ///////////////////////////////////////////////////////////////////////////

    ///

    ///  CREATE

    ///

    ///////////////////////////////////////////////////////////////////////////























    ///////////////////////////////////////////////////////////////////////////

    ///

    ///  RETRIEVE

    ///

    ///////////////////////////////////////////////////////////////////////////







    /**

    * Returns a count of votes for a certain color.

    *

    * @param     $sColor  The color for which we want to count votes

    * @return    $iResult The count

    */

    public function getVote($sColor='white')

        {

        $sColor     = strtolower($sColor);

        $iResult    = 0;

        $sSql       = "SELECT SUM(votes) AS CNT FROM votes where color = '".$sColor."'";

        $aResult    = $this->__doSelect($sSql);



        $iResult    = $aResult[0]['CNT'];

        if($iResult == null){$iResult = 0;}



        $this->__doEcho($aResult, "GET: $sSql");



        return $iResult;

        }

    //endFunction









    /**

    * Returns an array of all votes

    *

    * @return    $aResult  Array of votes

    */

    public function getVotes()

        {

        $sSql       = "SELECT * FROM votes";

        $aResult    = $this->__doSelect($sSql);



        $this->__doEcho($aResult, "GET: $sSql");



        return $aResult;

        }

    //endFunction









    /**

    * Returns an array of all colors

    *

    * @return    $aResult  Array of colors

    */

    public function getColors()

        {

        $sSql       = "SELECT * FROM colors";

        $aResult    = $this->__doSelect($sSql);



        $this->__doEcho($aResult, "GET: $sSql");



        return $aResult;

        }

    //endFunction











    ///////////////////////////////////////////////////////////////////////////

    ///

    ///  UPDATE

    ///

    ///////////////////////////////////////////////////////////////////////////













    ///////////////////////////////////////////////////////////////////////////

    ///

    ///  DELETE

    ///

    ///////////////////////////////////////////////////////////////////////////

















    ///////////////////////////////////////////////////////////////////////////

    ///

    ///  MISC

    ///

    ///////////////////////////////////////////////////////////////////////////









    /**

    * Escapes a string for inserting in database

    *

    * @param     $sValue  The string to be escaped

    * @return    $sResult The escaped string

    *

    */

    private function __doEscape($sValue)

        {

        $sResult = (get_magic_quotes_gpc()) ?  $sValue : addslashes($sValue);

        return  $sResult;

        }

    //endFunction











    /**

    * Unescapes a string retrieved from database

    *

    * @param     $sValue  The string to be escaped

    * @return    $sResult The escaped string

    *

    */

    private function __doUnEscape($sValue)

        {

        $sResult = (get_magic_quotes_gpc()) ?  $sValue : stripslashes($sValue);

        return  $sResult;

        }

    //endFunction







    /**

    * Encrypts a string for database operations

    *

    * @param    $sValue  The string to be encrypted

    * @return   $sResult The encrypted string

    *

    * @note     the php function crypt() only returns the first 13 characters of

    *           the hashed string, thus we reverse the string for salt to make sure

    *           that the hashed value changes with even small changes in the input

    */

    public function doEncrypt($sInput)

        {

        $sSalt      = strrev($sInput); // use the input as the salt

        $sOutput    = crypt($sInput, $sSalt);

        return $sOutput;

        }

    //endFunction





    /////////////////////////////////////////////////

    //

    //  Private functions

    //

    /////////////////////////////////////////////////









    /**

    * Sets the database connection.  Creates the database if it does not exist.

    *

    * @param     $sDbName  The database name

    * @return    $bResult  Connection success

    * @exception PDOException

    *

    */

    function __getDatabase($sDbName)

        {

        $bResult = TRUE;



          // If the folder does not exist, create it

        ///////////////////////////////////////////////////////

        if(file_exists($this->sFolder))

            {

            $bResult = TRUE;

            }

        else

            {

            $bResult = mkdir($this->sFolder, 0777, TRUE);

            }

        //endIf



        $bResult = $bResult && is_dir($this->sFolder) && is_writeable($this->sFolder);





        // If the database does not exist, create it

        ///////////////////////////////////////////////////////

        if($bResult)

            {

            try

                {

                $sPath              = $this->sFolder.$sDbName.'.sqlite';



                $this->database     = new PDO('sqlite:'.$sPath);

                $this->database->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

                }

            catch(PDOException $e)

                {

                // Print PDOException message

                echo "PDO EXCEPTION: ".$e->getMessage();

                $this->database = null;

                $bResult        = FALSE;

                }

            //endTryCatch

            }

        //endIf



        $this->__doEcho($bResult, "__getDatabase:");



        return $bResult;

        }

    //endFunction













    /**

    * Tests for connection to a table.

    *

    * @param     $sTableName    The table name

    * @return    $bResult       Operation success (indicated the table exists)

    * @exception PDOException

    */

    private function __getTable($sTableName)

        {

        $bResult = TRUE;



        // Check if the table exists

        /////////////////////////////////////////



        $sSql       = "SELECT count(*) as CNT FROM sqlite_master WHERE type='table' AND name='".$sTableName."'";

        $aResult    = $this->__doSelect($sSql);





        if($aResult === FALSE || !isset($aResult[0]) || !isset($aResult[0]['CNT']) || $aResult[0]['CNT'] === 0) {$bResult = FALSE;}



        $this->__doEcho($bResult, "__getTable: ( $sTableName ) : $sSql :");



        return $bResult;

        }

    //endFunction



























    /**

    * Performs a select query

    *

    * @param     $sSql      SQL for an insert or update

    * @return    $aResult   array

    * @exception PDOException

    *

    */

    private function __doSelect($sSql)

        {

        $aResult = array();

        if($this->bConnected)

            {

            try

                {

                $oResult    = $this->database->query($sSql);



                if($oResult !== FALSE){$aResult = $oResult->fetchAll(PDO::FETCH_ASSOC);}

                }

            catch(PDOException $e)

                {

                // Print PDOException message

                echo "doSelect PDO EXCEPTION: ".$e->getMessage()." SQL: ".$sSql."<br/>";

                }

            //endTryCatch

            }

        //endIf



        $this->__doEcho($aResult, "__doSelect: $sSql : RESULT:");



        return $aResult;

        }

    //endIf













    /**

    * Performs an insert, delete, or update query

    *

    * @param     $sSql                          SQL for an insert or update

    * @return    PDOStatement Object || FALSE

    * @exception PDOException

    *

    */

    private function __doExec($sSql)

        {

        //$this->database->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); // for more verbose error tracking



        $oResult = FALSE;



        if($this->bConnected)

            {

            try

                {

                $oResult    = $this->database->query($sSql);

                }

            catch(PDOException $e)

                {

                // Print PDOException message

                echo "doExec PDO EXCEPTION: SQL: ". $sSql, $e->getMessage()."<br/>";

                }

            //endTryCatch

            }

        //endIf



        // $oResult can be FALSE || PDOStatement object



        $this->__doEcho($oResult, "__doExec: $sSql");



        return $oResult;

        }

    //endIf











    /**

    * Performs an update query

    *

    * @param     $sSql      SQL for an update

    * @return    $bResult   Operation success

    *

    */

    private function __doUpdate($sSql)

        {

        $bResult = FALSE;

        $oResult = $this->__doExec($sSql);



        if($oResult !== FALSE){$bResult = TRUE;}



        return $bResult;

        }

    //endIf









    /**

    * Performs an insert query

    *

    * @param     $sSql      SQL for an insert

    * @return    $bResult   Operation success

    *

    */

    private function __doInsert($sSql)

        {

        $bResult = FALSE;

        $oResult = $this->__doExec($sSql);



        if($oResult !== FALSE){$bResult = TRUE;}



        return $bResult;

        }

    //endIf









    /**

    * Performs a delete query

    *

    * @param     $sSql      SQL for a delete

    * @return    $bResult   Operation success

    *

    */

    private function __doDelete($sSql, $oDatabase)

        {

        $bResult = FALSE;

        $oResult = $this->__doExec($sSq);



        if($oResult !== FALSE){$bResult = TRUE;}



        return $bResult;

        }

    //endIf







    /**

    * Dumps diagnostic data to the screen

    *

    * @param     $mObject  The data to dump

    * @return    $sLabel   The label for the data

    *

    */

    private function __doEcho($mObject, $sLabel)

        {

        if($this->bDebug)

            {

            echo "DAO: $sLabel: <br/><br/>";

            echo "<pre>";

            print_r($mObject);

            echo "</pre>";

            }

        //endIf

        }

    //endFunction





    }

//endClass

?>